/*
 * Decompiled with CFR 0.152.
 */
package com.doc.data;

import com.dto.LoginDto;
import com.dto.PaymentDetailDto;
import com.security.SecurityConstants;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncJdbc;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class DocumentDao {
    private final DbConnection dbConnection;

    public void insertDocDtls(List<PaymentDetailDto> dtlList) {
        LoginDto myLogin = SecurityConstants.loadToken();
        TncJdbc jdbc = this.dbConnection.getJdbcTemplate(myLogin);
        if (ConvertStr.isNullOrEmpty(dtlList)) {
            return;
        }
        StringBuilder sb = new StringBuilder(" Insert Into Snd_List(Sanad_Code, Col_Code, Moien_Code, Tafzili_Code, \n Bed, Bes, Joze, Show_Daftar,Type_Line, Comment_Line, Number_Line, Actions) \n Values \n");
        for (PaymentDetailDto dtl : dtlList) {
            sb.append("(").append(dtl.getDocCode()).append(",'").append(dtl.getColcode()).append("','").append(dtl.getMoiencode()).append("','").append(dtl.getTafzilicode()).append("',").append(dtl.getBed()).append(",").append(dtl.getBes()).append(",").append(ConvertStr.getBoolToInt((Boolean)dtl.getJoze())).append(",").append(ConvertStr.getBoolToInt((Boolean)dtl.getShowdaftar())).append(",'").append(dtl.getTypeline()).append("','").append(dtl.getCommentline()).append("',").append(dtl.getNumberline()).append(",").append(dtl.getActions()).append("), \n");
        }
        jdbc.execute(ConvertStr.removeFromStringBuilderLastIndexOf((StringBuilder)sb, (String)", \n").toString());
    }

    public DocumentDao(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

